<?php

namespace backend\controllers;

use Yii;
use backend\models\Admin;
use backend\models\AdminSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use \yii\web\Response;
use yii\helpers\Html;

/**
 * AdminController implements the CRUD actions for Admin model.
 */
class AdminController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Admin models.
     * @return mixed
     */
    public function actionIndex()
    {    
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            return $this->goHome();
        }
        $searchModel = new AdminSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Creates a new Admin model.
     * For ajax request will return json object
     * and for non-ajax request if creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $request = Yii::$app->request;
        $model = new Admin();  

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Create new Admin",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default btn-twilight  pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary btn-bright','type'=>"submit"])
        
                ];         
            }else if($model->load($request->post())){
                $model->groups = ($model->groups) ? json_encode($model->groups) : '[]';
                $model->setPassword($model->new_password);
                if(Admin::findOne(['login' => $model->login])){
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> 'Warning!',
                        'content' => '<b>'.$model->login."</b> Such name already exist!",
                        'footer'=> Html::button(' Ok ',['class'=>'btn btn-primary pull-right btn-bright','data-dismiss'=>"modal"])
                    ]; 
                }
                if($model->save(false)){
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> '',
                        'content' => '<b>'.$model->login."</b> Successfully created!",
                        'footer'=> Html::button(' Ok ',['class'=>'btn btn-primary pull-right btn-bright','data-dismiss'=>"modal"])
                    ]; 
                }         
            }else{           
                return [
                    'title'=> "Create new Admin",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default btn-twilight pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary btn-bright','type'=>"submit"])
        
                ];         
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }
       
    }

    /**
     * Updates an existing Admin model.
     * For ajax request will return json object
     * and for non-ajax request if update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $request = Yii::$app->request;
        $model = $this->findModel($id);       

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Update : <b>".$model->login.'</b>',
                    'content'=>$this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default btn-twilight pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary btn-bright','type'=>"submit"])
                ];         
            }else if($model->load(Yii::$app->request->post())) {
                
                $model->groups = ($model->groups) ? json_encode($model->groups) : '[]';

                if($model->confirm_password != ''  && $model->new_password != ''){
                    if($model->confirm_password == $model->new_password){
                        $model->setPassword($model->new_password);

                    }
                }

                if ($model->validate() && $model->save()) {
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> '',
                        'content' => '<b>'.$model->login."</b> Successfully saved!",
                        'footer'=> Html::button(' Ok ',['class'=>'btn btn-primary pull-right btn-bright','data-dismiss'=>"modal"])
                    ]; 
                }else{
                    $res = '';
                    foreach ($model->errors as $key => $value) {
                        foreach ($value as $k => $v) {
                            $res .= $v.'<br>';
                        }
                    }
                    return [
                        'title' => 'Validation Error!',
                        'content' => $res,
                        'footer'=> Html::button(' Ok ',['class'=>'btn btn-primary pull-right btn-bright','data-dismiss'=>"modal"])
                    ];

                }
                   
            }else{
                 return [
                    'title'=> "Update : ".$model->login,
                    'content'=>$this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default  btn-twilight pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary btn-bright','type'=>"submit"])
                ];        
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save(false)) {
                $model->setPassword($model->new_password);
                $model->save(false);
                return $this->goHome();
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }
    }

    /**
     * Delete an existing Admin model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $request = Yii::$app->request;
        $this->findModel($id)->delete();

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }


    }

     /**
     * Delete multiple existing Admin model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionBulkDelete()
    {        
        $request = Yii::$app->request;
        $pks = explode(',', $request->post( 'pks' )); // Array or selected records primary keys
        foreach ( $pks as $pk ) {
            $model = $this->findModel($pk);
            $model->delete();
        }

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }
       
    }

    /**
     * Finds the Admin model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Admin the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Admin::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
